<div class="flex flex-col lg:flex-row">
    <div class="w-full lg:w-1/2">
        <div class="border-b px-2 pb-3">
            <h1 class="flex items-center text-2xl xl:text-5xl text-black font-light -ml-0.5">
                <?php echo $title; ?>

            </h1>

            <p class="mt-6 text-sm">
                <?php echo $description; ?>

            </p>
        </div>

        <ul>
            <?php $__currentLoopData = $buttons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($checkPermissionCreate): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check($button['permission'])): ?>
                <?php endif; ?>
                    <li class="border-b p-2 hover:bg-gray-100">
                        <a href="<?php echo e($button['url']); ?>" class="flex items-center justify-between text-xs">
                            <div class="truncate">
                                <div class="flex items-center">
                                    <h2 class="relative">
                                        <?php echo e($button['text']); ?>


                                        <?php if(! empty($button['active_badge'])): ?>
                                            <div class="absolute w-7 h-7 opacity-100 z-20 -top-1.5 -right-8">
                                                <div class="absolute w-5 h-5 left-0 top-1 border border-gray-100 rounded-full animate-pulsate_transparent bg-white"></div>
                                                <div class="absolute w-2 h-2 top-2.5 left-1.5 rounded-full bg-green-400"></div>
                                            </div>
                                        <?php endif; ?>
                                    </h2>
                                </div>

                                <div class="h-4 overflow-hidden text-black-400 truncate"><?php echo e($button['description']); ?></div>
                            </div>

                            <span class="material-icons text-gray-500 transform rtl:rotate-180">chevron_right</span>
                        </a>
                    </li>
                <?php if($checkPermissionCreate): ?>
                <?php endif; ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if(! empty($suggestion)): ?>
                <li class="border-b p-2  hover:bg-gray-100">
                    <a href="<?php echo e(url($suggestion->action_url) . '?' . http_build_query((array) $suggestion->action_parameters)); ?>" class="flex items-center justify-between text-xs">
                        <div class="truncate">
                            <h2>
                                <?php echo e($suggestion->name); ?>

                            </h2>

                            <div class="h-4 overflow-hidden text-black-400 truncate">
                                <?php echo e($suggestion->description ?? ''); ?>

                            </div>
                        </div>

                        <span class="material-icons text-gray-500">chevron_right</span>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>

    <div class="w-full lg:w-1/2 flex justify-end lg:mt-60">
        <img src="<?php echo e($image); ?>" alt="<?php echo e($title); ?>" />
    </div>
</div>

<?php $__env->startPush('css'); ?>
    <style>
        .hide-empty-page {
            display: none;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/accesse1/public_html/Web-Apps-Production/Akaunting-306/resources/views/components/empty-page.blade.php ENDPATH**/ ?>