-- phpMyAdmin SQL Dump
-- version 4.5.1
-- http://www.phpmyadmin.net
--
-- Host: 127.0.0.1
-- Generation Time: Nov 02, 2016 at 08:52 AM
-- Server version: 10.1.13-MariaDB
-- PHP Version: 5.6.23

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `metalims_empty`
--

-- --------------------------------------------------------
CREATE DATABASE `metalims_empty`;

CREATE USER 'metalims'@'localhost' IDENTIFIED BY 'metalims_password123';

GRANT INSERT ON metalims_empty.* TO 'metalims'@'localhost';

GRANT SELECT ON metalims_empty.* TO 'metalims'@'localhost';

GRANT UPDATE ON metalims_empty.* TO 'metalims'@'localhost';

GRANT DELETE ON metalims_empty.* TO 'metalims'@'localhost';

FLUSH PRIVILEGES;

USE `metalims_empty`;



--
-- Table structure for table `analysis`
--


CREATE TABLE `analysis` (
  `analysis_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `application`
--

CREATE TABLE `application` (
  `application` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `application_abbrev` varchar(10) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `application`
--

INSERT INTO `application` (`application`, `visible`, `application_abbrev`) VALUES
('Amplicon sequencing', 1, 'A' ),
('ChIP-sequencing', 1, 'C'),
('Exome sequencing', 1, 'E'),
('Metagenome PacBio', 1, 'MP'),
('Metagenome sequencing', 1, 'M'),
('Metatranscriptome sequencing', 1, 'MT'),
('PacBio Isolates', 1, 'P'),
('Small RNA sequencing', 1, 'S'),
('Transcriptome Sequencing', 1, 'T'),
('Whole genome sequencing', 1, 'W');

-- --------------------------------------------------------

--
-- Table structure for table `container_type`
--

CREATE TABLE `container_type` (
  `container_type` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `container_type`
--

INSERT INTO `container_type` (`container_type`, `visible`) VALUES
('384 well plate', 1),
('96 well plate', 1),
('Tube', 1);

-- --------------------------------------------------------

--
-- Table structure for table `create_user_things`
--

CREATE TABLE `create_user_things` (
  `thing_id` int(11) NOT NULL,
  `label_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `select_values` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `required` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `daily_data2`
--

CREATE TABLE `daily_data2` (
  `daily_date` date NOT NULL,
  `location` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `notes` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `entered_by` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `updated_by` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `update_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `orig_time_stamp` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `daily_data2_particle_counter`
--

CREATE TABLE `daily_data2_particle_counter` (
  `daily_date` date NOT NULL,
  `part_sens_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `location` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `avg_measurement` decimal(6,2) NOT NULL,
  `record_source` varchar(150) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `dna_extraction`
--

CREATE TABLE `dna_extraction` (
  `d_kit_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `drawer`
--

CREATE TABLE `drawer` (
  `drawer_id` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `drawer`
--

INSERT INTO `drawer` (`drawer_id`, `visible`) VALUES
('Used', 1);

-- --------------------------------------------------------

--
-- Table structure for table `freezer`
--

CREATE TABLE `freezer` (
  `freezer_id` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `freezer`
--

INSERT INTO `freezer` (`freezer_id`, `visible`) VALUES
('Used', 1);

-- --------------------------------------------------------

--
-- Table structure for table `freezer_drawer`
--

CREATE TABLE `freezer_drawer` (
  `freezer_id` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `drawer_id` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `visible_flag` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `freezer_drawer`
--

INSERT INTO `freezer_drawer` (`freezer_id`, `drawer_id`, `visible_flag`) VALUES
('Used', 'Used', 1);

-- --------------------------------------------------------

--
-- Table structure for table `library_prep_kit`
--

CREATE TABLE `library_prep_kit` (
  `lib_prep_kit` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `library_prep_kit`
--

INSERT INTO `library_prep_kit` (`lib_prep_kit`, `visible`) VALUES
('Low Input Library Prep Kit', 1),
('Nextera DNA Library Preparation Kit', 1);

-- --------------------------------------------------------

--
-- Table structure for table `location`
--

CREATE TABLE `location` (
  `loc_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `loc_type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `environmental_type` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `latitude` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `longitude` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `location`
--

INSERT INTO `location` (`loc_name`, `address`, `loc_type`, `environmental_type`, `latitude`, `longitude`, `visible`) VALUES
('(pooled)', '', '', '', '', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `media_type`
--

CREATE TABLE `media_type` (
  `media_type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `media_type`
--

INSERT INTO `media_type` (`media_type`, `visible`) VALUES
('(pooled)', 1),
('N/A', 1);

-- --------------------------------------------------------

--
-- Table structure for table `number_of_seq_submissions`
--

CREATE TABLE `number_of_seq_submissions` (
  `sample_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `A` int(3) NOT NULL DEFAULT '0',
  `C` int(3) NOT NULL DEFAULT '0',
  `E` int(3) NOT NULL DEFAULT '0',
  `MP` int(3) DEFAULT '0',
  `M` int(3) NOT NULL DEFAULT '0',
  `MT` int(3) NOT NULL DEFAULT '0',
  `S` int(3) NOT NULL DEFAULT '0',
  `T` int(3) NOT NULL DEFAULT '0',
  `G` int(3) NOT NULL DEFAULT '0',
  `P` int(3) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `particle_counter`
--

CREATE TABLE `particle_counter` (
  `part_sens_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `sensor_type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `serial_num` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `pooled_sample_lookup`
--

CREATE TABLE `pooled_sample_lookup` (
  `new_pooled_samp_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `orig_sample_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `date_entered` date NOT NULL,
  `entered_by` varchar(150) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `project_name`
--

CREATE TABLE `project_name` (
  `project_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `added_by` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `seq_id_start` varchar(6) COLLATE utf8_unicode_ci NOT NULL,
  `time_stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `quantitation_method`
--

CREATE TABLE `quantitation_method` (
  `quant_method` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `quantitation_method`
--

INSERT INTO `quantitation_method` (`quant_method`, `visible`) VALUES
('Picogreen', 1),
('Qubit DNA', 1),
('Qubit RNA', 1),
('Ribogreen', 1);

-- --------------------------------------------------------

--
-- Table structure for table `quant_instruments`
--

CREATE TABLE `quant_instruments` (
  `kit_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `quant_instruments`
--

INSERT INTO `quant_instruments` (`kit_name`, `visible`) VALUES
('PicoGreen', 1),
('Qubit', 1);

-- --------------------------------------------------------

--
-- Table structure for table `read_length`
--

CREATE TABLE `read_length` (
  `read_length` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `read_length`
--

INSERT INTO `read_length` (`read_length`, `visible`) VALUES
('100bp (HiSeq)', 1),
('150bp (HiSeq)', 1),
('150bp (MiSeq)', 1),
('250bp (HiSeq)', 1),
('300bp (MiSeq)', 1),
('50bp (HiSeq)', 1),
('50bp (MiSeq)', 1),
('75bp (HiSeq)', 1),
('75bp (MiSeq)', 1);

-- --------------------------------------------------------

--
-- Table structure for table `read_submission`
--

CREATE TABLE `read_submission` (
  `sample_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `subm_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `subm_db` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subm_date` date DEFAULT NULL,
  `submitter` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type_exp` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `time_stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `read_subm_database`
--

CREATE TABLE `read_subm_database` (
  `database_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `read_subm_database`
--

INSERT INTO `read_subm_database` (`database_name`, `visible`) VALUES
('DDBJ', 1),
('ENA', 1),
('GenBank', 1);

-- --------------------------------------------------------

--
-- Table structure for table `read_subm_exp_types`
--

CREATE TABLE `read_subm_exp_types` (
  `exp_types` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `read_subm_exp_types`
--

INSERT INTO `read_subm_exp_types` (`exp_types`, `visible`) VALUES
('Eukaryotic Genomic Sequences MIGS-Genome, metagenome or marker sequences (MIxS compliant)', 1),
('Cultured Bacterial/Archaeal Genomic Sequences MIGS-Genome, metagenome or marker sequences (MIxS compliant)', 1),
('Environmental/Metagenome Genomic Sequences MIMS -Genome, metagenome or marker sequences (MIxS compliant)', 1),
('Human sample', 1),
('Invertebrate', 1),
('Metagenome or environmental sample', 1),
('Microbe', 1),
('Model organism or animal sample', 1),
('Pathogen affecting public health', 1),
('Plant sample', 1),
('Specimen Marker Sequences MIMARKS-Genome, metagenome or marker sequences (MIxS compliant)', 1),
('Survey-related Marker Sequences MIMARKS-Genome, metagenome or marker sequences (MIxS compliant)', 1),
('Viral Genomic Sequences MIGS-Genome, metagenome or marker sequences (MIxS compliant)', 1),
('Virus sample', 1);

-- --------------------------------------------------------

--
-- Table structure for table `records`
--

CREATE TABLE `records` (
  `records` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `relt_location`
--

CREATE TABLE `relt_location` (
  `loc_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `relt_location`
--

INSERT INTO `relt_location` (`loc_name`, `visible`) VALUES
('(pooled)', 1);

-- --------------------------------------------------------

--
-- Table structure for table `rna_extraction`
--

CREATE TABLE `rna_extraction` (
  `r_kit_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sample`
--

CREATE TABLE `sample` (
  `sample_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `sample_num` int(3) NOT NULL,
  `sample_sort` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `analysis_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `barcode` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `collector_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `d_conc` decimal(10,2) DEFAULT NULL,
  `d_conc_instrument` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `d_extraction_date` date DEFAULT NULL,
  `dExtrName` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `d_volume` float DEFAULT NULL,
  `d_volume_quant` float DEFAULT NULL,
  `dna_extract_kit_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `daily_data` date DEFAULT NULL,
  `end_samp_date_time` datetime DEFAULT NULL,
  `entered_by` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `location_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `media_type` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` mediumtext COLLATE utf8_unicode_ci,
  `orig_time_stamp` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `part_of_pool` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  `pool_extracts_id` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pooled_flag` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'NP',
  `project_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `r_conc` decimal(10,2) DEFAULT NULL,
  `r_conc_instrument` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `r_extraction_date` date DEFAULT NULL,
  `rExtrName` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `r_volume` float DEFAULT NULL,
  `r_volume_quant` float DEFAULT NULL,
  `rna_extract_kit_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `relt_loc_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `sample_type` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `seq_id` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `sequencing_info` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `start_samp_date_time` datetime DEFAULT NULL,
  `time_stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total_samp_time` float(10,4) DEFAULT NULL,
  `updated_by` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sampler`
--

CREATE TABLE `sampler` (
  `sampler_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `serial_num` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sampler_identifier` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `sampler`
--

INSERT INTO `sampler` (`sampler_name`, `serial_num`, `sampler_identifier`, `visible`) VALUES
('(pooled)', NULL, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sample_sampler`
--

CREATE TABLE `sample_sampler` (
  `sample_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `sampler_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `start_date_time` datetime NOT NULL,
  `end_date_time` datetime NOT NULL,
  `total_date_time` float NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sample_sequencing2`
--

CREATE TABLE `sample_sequencing2` (
  `sample_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `seq_id` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `seq_sub_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dna_conc` decimal(6,3) DEFAULT NULL,
  `vol` decimal(5,2) DEFAULT NULL,
  `wellLoc` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sampBuffer` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nano` decimal(6,3) DEFAULT NULL,
  `a_280` decimal(6,3) DEFAULT NULL,
  `a_230` decimal(6,3) DEFAULT NULL,
  `dnaCont` int(3) DEFAULT NULL,
  `RIN` decimal(3,1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sample_type`
--

CREATE TABLE `sample_type` (
  `sample_type_id` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `sample_type_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `sample_type`
--

INSERT INTO `sample_type` (`sample_type_id`, `sample_type_name`, `visible`) VALUES
('A', 'Air', 1),
('B', 'Blank-Sterilization', 1),
('P', 'Pooled', 1),
('S', 'Soil', 1),
('W', 'Water', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sequencing2`
--

CREATE TABLE `sequencing2` (
  `sequencing_info` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `container_type` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_submitted` date DEFAULT NULL,
  `dna_conc_of_subm` decimal(5,2) DEFAULT NULL,
  `entered_by` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `library_prep_kit` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sample_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `seqOther` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sequencer_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sequencing_method` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sequencing_type` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `submitted_by` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `primerL` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `primerR` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quant_method` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `read_length` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `volume_of_aliquot` float DEFAULT NULL,
  `seq_pool` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amplicon_type` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `results_recieved` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sequencing_method`
--

CREATE TABLE `sequencing_method` (
  `method` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `sequencing_method`
--

INSERT INTO `sequencing_method` (`method`, `visible`) VALUES
('Indexed Paired End', 1),
('Indexed Single Read', 1),
('Paired End', 1),
('Single Read', 1);

-- --------------------------------------------------------

--
-- Table structure for table `storage_info`
--

CREATE TABLE `storage_info` (
  `sample_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `original` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `remaining` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orig_sample_exists` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `dna_extr` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `DNA_sample_exists` varchar(5) COLLATE utf8_unicode_ci DEFAULT 'two',
  `rna_extr` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `RNA_sample_exists` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'two',
  `time_stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `thing_storing`
--

CREATE TABLE `thing_storing` (
  `sample_name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `thing_id` int(11) NOT NULL,
  `thing_value` varchar(300) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `type_seq_sample`
--

CREATE TABLE `type_seq_sample` (
  `sample_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `visible` tinyint(1) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `type_seq_sample`
--

INSERT INTO `type_seq_sample` (`sample_type`, `visible`) VALUES
('Amplicon', 1),
('cDNA', 1),
('Genomic DNA', 1),
('Library', 1),
('Purified mRNA', 1),
('Purified small RNA', 1),
('Single-stranded DNA', 1),
('Total RNA', 1);

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `first_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `last_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `session_id` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `time` float NOT NULL,
  `status` varchar(7) COLLATE utf8_unicode_ci NOT NULL,
  `pkey` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `visible` varchar(1) COLLATE utf8_unicode_ci DEFAULT '1',
  `admin` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  `first_failed_login` int(11) DEFAULT '0',
  `failed_login_count` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`user_id`, `first_name`, `last_name`, `password`, `session_id`, `time`, `status`, `pkey`, `visible`, `admin`, `first_failed_login`, `failed_login_count`) VALUES
('admin@metalims.com', 'Admin', '', '$2y$10$YSaGTh/gr018WJe70o1E6.LmIAgOKqJIywwFgE5TEwmk4jfSAuB46', 'o7ihau24cu5kiqvdh5ct39mjo4', 1477730000, 'done', '9d63f2f4ace1f815753a6f748e2dc0a60c5cfabbe76520f5eb6eef7d5a49fd9d', '1', 'Y', 1477835780, 1);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `analysis`
--
ALTER TABLE `analysis`
  ADD PRIMARY KEY (`analysis_name`);

--
-- Indexes for table `application`
--
ALTER TABLE `application`
  ADD PRIMARY KEY (`application`);

--
-- Indexes for table `container_type`
--
ALTER TABLE `container_type`
  ADD PRIMARY KEY (`container_type`);

--
-- Indexes for table `create_user_things`
--
ALTER TABLE `create_user_things`
  ADD PRIMARY KEY (`thing_id`);

--
-- Indexes for table `daily_data2`
--
ALTER TABLE `daily_data2`
  ADD PRIMARY KEY (`daily_date`,`location`),
  ADD KEY `location` (`location`);

--
-- Indexes for table `daily_data2_particle_counter`
--
ALTER TABLE `daily_data2_particle_counter`
  ADD PRIMARY KEY (`daily_date`,`location`,`part_sens_name`),
  ADD KEY `part_sens_name` (`part_sens_name`),
  ADD KEY `location` (`location`),
  ADD KEY `record_source` (`record_source`);

--
-- Indexes for table `dna_extraction`
--
ALTER TABLE `dna_extraction`
  ADD PRIMARY KEY (`d_kit_name`);

--
-- Indexes for table `drawer`
--
ALTER TABLE `drawer`
  ADD PRIMARY KEY (`drawer_id`);

--
-- Indexes for table `freezer`
--
ALTER TABLE `freezer`
  ADD PRIMARY KEY (`freezer_id`);

--
-- Indexes for table `freezer_drawer`
--
ALTER TABLE `freezer_drawer`
  ADD PRIMARY KEY (`freezer_id`,`drawer_id`),
  ADD KEY `drawer_id` (`drawer_id`);

--
-- Indexes for table `library_prep_kit`
--
ALTER TABLE `library_prep_kit`
  ADD PRIMARY KEY (`lib_prep_kit`);

--
-- Indexes for table `location`
--
ALTER TABLE `location`
  ADD PRIMARY KEY (`loc_name`);

--
-- Indexes for table `media_type`
--
ALTER TABLE `media_type`
  ADD PRIMARY KEY (`media_type`);

--
-- Indexes for table `number_of_seq_submissions`
--
ALTER TABLE `number_of_seq_submissions`
  ADD PRIMARY KEY (`sample_name`);

--
-- Indexes for table `particle_counter`
--
ALTER TABLE `particle_counter`
  ADD PRIMARY KEY (`part_sens_name`);

--
-- Indexes for table `pooled_sample_lookup`
--
ALTER TABLE `pooled_sample_lookup`
  ADD PRIMARY KEY (`new_pooled_samp_name`,`orig_sample_name`),
  ADD KEY `orig_sample_name` (`orig_sample_name`);

--
-- Indexes for table `project_name`
--
ALTER TABLE `project_name`
  ADD PRIMARY KEY (`project_name`);

--
-- Indexes for table `quantitation_method`
--
ALTER TABLE `quantitation_method`
  ADD PRIMARY KEY (`quant_method`);

--
-- Indexes for table `quant_instruments`
--
ALTER TABLE `quant_instruments`
  ADD PRIMARY KEY (`kit_name`);

--
-- Indexes for table `read_length`
--
ALTER TABLE `read_length`
  ADD PRIMARY KEY (`read_length`);

--
-- Indexes for table `read_submission`
--
ALTER TABLE `read_submission`
  ADD PRIMARY KEY (`sample_name`,`subm_id`),
  ADD KEY `subm_db` (`subm_db`),
  ADD KEY `type_exp` (`type_exp`);

--
-- Indexes for table `read_subm_database`
--
ALTER TABLE `read_subm_database`
  ADD PRIMARY KEY (`database_name`);

--
-- Indexes for table `read_subm_exp_types`
--
ALTER TABLE `read_subm_exp_types`
  ADD PRIMARY KEY (`exp_types`);

--
-- Indexes for table `records`
--
ALTER TABLE `records`
  ADD PRIMARY KEY (`records`);

--
-- Indexes for table `relt_location`
--
ALTER TABLE `relt_location`
  ADD PRIMARY KEY (`loc_name`);

--
-- Indexes for table `rna_extraction`
--
ALTER TABLE `rna_extraction`
  ADD PRIMARY KEY (`r_kit_name`);

--
-- Indexes for table `sample`
--
ALTER TABLE `sample`
  ADD PRIMARY KEY (`sample_name`),
  ADD KEY `analysis_name` (`analysis_name`),
  ADD KEY `media_type` (`media_type`),
  ADD KEY `location_name` (`location_name`),
  ADD KEY `relt_loc_name` (`relt_loc_name`),
  ADD KEY `project_name` (`project_name`),
  ADD KEY `sample_type` (`sample_type`),
  ADD KEY `dna_extract_kit_name` (`dna_extract_kit_name`),
  ADD KEY `d_conc_instrument` (`d_conc_instrument`),
  ADD KEY `r_conc_instrument` (`r_conc_instrument`),
  ADD KEY `rna_extract_kit_name` (`rna_extract_kit_name`);

--
-- Indexes for table `sampler`
--
ALTER TABLE `sampler`
  ADD PRIMARY KEY (`sampler_name`);

--
-- Indexes for table `sample_sampler`
--
ALTER TABLE `sample_sampler`
  ADD PRIMARY KEY (`sample_name`,`sampler_name`),
  ADD KEY `sampler_name` (`sampler_name`);

--
-- Indexes for table `sample_sequencing2`
--
ALTER TABLE `sample_sequencing2`
  ADD PRIMARY KEY (`sample_name`,`seq_id`),
  ADD KEY `seq_id` (`seq_id`);

--
-- Indexes for table `sample_type`
--
ALTER TABLE `sample_type`
  ADD PRIMARY KEY (`sample_type_id`);

--
-- Indexes for table `sequencing2`
--
ALTER TABLE `sequencing2`
  ADD PRIMARY KEY (`sequencing_info`),
  ADD KEY `container_type` (`container_type`),
  ADD KEY `library_prep_kit` (`library_prep_kit`),
  ADD KEY `sample_type` (`sample_type`),
  ADD KEY `sequencing_method` (`sequencing_method`),
  ADD KEY `quant_method` (`quant_method`),
  ADD KEY `read_length` (`read_length`),
  ADD KEY `sequencing_type` (`sequencing_type`);

--
-- Indexes for table `sequencing_method`
--
ALTER TABLE `sequencing_method`
  ADD PRIMARY KEY (`method`);

--
-- Indexes for table `storage_info`
--
ALTER TABLE `storage_info`
  ADD PRIMARY KEY (`sample_name`);

--
-- Indexes for table `thing_storing`
--
ALTER TABLE `thing_storing`
  ADD PRIMARY KEY (`sample_name`,`thing_id`),
  ADD KEY `thing_id` (`thing_id`);

--
-- Indexes for table `type_seq_sample`
--
ALTER TABLE `type_seq_sample`
  ADD PRIMARY KEY (`sample_type`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`user_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `create_user_things`
--
ALTER TABLE `create_user_things`
  MODIFY `thing_id` int(11) NOT NULL AUTO_INCREMENT;
--
-- Constraints for dumped tables
--

--
-- Constraints for table `daily_data2`
--
ALTER TABLE `daily_data2`
  ADD CONSTRAINT `daily_data2_ibfk_1` FOREIGN KEY (`location`) REFERENCES `location` (`loc_name`) ON UPDATE CASCADE;

--
-- Constraints for table `daily_data2_particle_counter`
--
ALTER TABLE `daily_data2_particle_counter`
  ADD CONSTRAINT `daily_data2_particle_counter_ibfk_1` FOREIGN KEY (`part_sens_name`) REFERENCES `particle_counter` (`part_sens_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `daily_data2_particle_counter_ibfk_2` FOREIGN KEY (`location`) REFERENCES `location` (`loc_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `daily_data2_particle_counter_ibfk_3` FOREIGN KEY (`record_source`) REFERENCES `records` (`records`) ON UPDATE CASCADE;

--
-- Constraints for table `freezer_drawer`
--
ALTER TABLE `freezer_drawer`
  ADD CONSTRAINT `freezer_drawer_ibfk_1` FOREIGN KEY (`freezer_id`) REFERENCES `freezer` (`freezer_id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `freezer_drawer_ibfk_2` FOREIGN KEY (`drawer_id`) REFERENCES `drawer` (`drawer_id`) ON UPDATE CASCADE;

--
-- Constraints for table `number_of_seq_submissions`
--
ALTER TABLE `number_of_seq_submissions`
  ADD CONSTRAINT `number_of_seq_submissions_ibfk_1` FOREIGN KEY (`sample_name`) REFERENCES `sample` (`sample_name`) ON UPDATE CASCADE;

--
-- Constraints for table `pooled_sample_lookup`
--
ALTER TABLE `pooled_sample_lookup`
  ADD CONSTRAINT `pooled_sample_lookup_ibfk_1` FOREIGN KEY (`new_pooled_samp_name`) REFERENCES `sample` (`sample_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `pooled_sample_lookup_ibfk_2` FOREIGN KEY (`orig_sample_name`) REFERENCES `sample` (`sample_name`) ON UPDATE CASCADE;

--
-- Constraints for table `read_submission`
--
ALTER TABLE `read_submission`
  ADD CONSTRAINT `read_submission_ibfk_1` FOREIGN KEY (`subm_db`) REFERENCES `read_subm_database` (`database_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `read_submission_ibfk_2` FOREIGN KEY (`type_exp`) REFERENCES `read_subm_exp_types` (`exp_types`) ON UPDATE CASCADE,
  ADD CONSTRAINT `read_submission_ibfk_3` FOREIGN KEY (`sample_name`) REFERENCES `sample` (`sample_name`) ON UPDATE CASCADE;

--
-- Constraints for table `sample`
--
ALTER TABLE `sample`
  ADD CONSTRAINT `sample_ibfk_1` FOREIGN KEY (`analysis_name`) REFERENCES `analysis` (`analysis_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_10` FOREIGN KEY (`sample_type`) REFERENCES `sample_type` (`sample_type_id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_2` FOREIGN KEY (`d_conc_instrument`) REFERENCES `quant_instruments` (`kit_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_3` FOREIGN KEY (`dna_extract_kit_name`) REFERENCES `dna_extraction` (`d_kit_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_4` FOREIGN KEY (`location_name`) REFERENCES `location` (`loc_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_5` FOREIGN KEY (`media_type`) REFERENCES `media_type` (`media_type`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_6` FOREIGN KEY (`project_name`) REFERENCES `project_name` (`project_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_7` FOREIGN KEY (`r_conc_instrument`) REFERENCES `quant_instruments` (`kit_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_8` FOREIGN KEY (`rna_extract_kit_name`) REFERENCES `rna_extraction` (`r_kit_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_ibfk_9` FOREIGN KEY (`relt_loc_name`) REFERENCES `relt_location` (`loc_name`) ON UPDATE CASCADE;

--
-- Constraints for table `sample_sampler`
--
ALTER TABLE `sample_sampler`
  ADD CONSTRAINT `sample_sampler_ibfk_1` FOREIGN KEY (`sample_name`) REFERENCES `sample` (`sample_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_sampler_ibfk_2` FOREIGN KEY (`sampler_name`) REFERENCES `sampler` (`sampler_name`) ON UPDATE CASCADE;

--
-- Constraints for table `sample_sequencing2`
--
ALTER TABLE `sample_sequencing2`
  ADD CONSTRAINT `sample_sequencing2_ibfk_1` FOREIGN KEY (`sample_name`) REFERENCES `sample` (`sample_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sample_sequencing2_ibfk_2` FOREIGN KEY (`seq_id`) REFERENCES `sequencing2` (`sequencing_info`) ON UPDATE CASCADE;

--
-- Constraints for table `sequencing2`
--
ALTER TABLE `sequencing2`
  ADD CONSTRAINT `sequencing2_ibfk_1` FOREIGN KEY (`container_type`) REFERENCES `container_type` (`container_type`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sequencing2_ibfk_2` FOREIGN KEY (`library_prep_kit`) REFERENCES `library_prep_kit` (`lib_prep_kit`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sequencing2_ibfk_3` FOREIGN KEY (`sequencing_method`) REFERENCES `sequencing_method` (`method`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sequencing2_ibfk_4` FOREIGN KEY (`sequencing_type`) REFERENCES `application` (`application`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sequencing2_ibfk_5` FOREIGN KEY (`quant_method`) REFERENCES `quantitation_method` (`quant_method`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sequencing2_ibfk_6` FOREIGN KEY (`read_length`) REFERENCES `read_length` (`read_length`) ON UPDATE CASCADE,
  ADD CONSTRAINT `sequencing2_ibfk_7` FOREIGN KEY (`sample_type`) REFERENCES `type_seq_sample` (`sample_type`) ON UPDATE CASCADE;

--
-- Constraints for table `storage_info`
--
ALTER TABLE `storage_info`
  ADD CONSTRAINT `storage_info_ibfk_1` FOREIGN KEY (`sample_name`) REFERENCES `sample` (`sample_name`) ON UPDATE CASCADE;

--
-- Constraints for table `thing_storing`
--
ALTER TABLE `thing_storing`
  ADD CONSTRAINT `thing_storing_ibfk_1` FOREIGN KEY (`sample_name`) REFERENCES `sample` (`sample_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `thing_storing_ibfk_2` FOREIGN KEY (`thing_id`) REFERENCES `create_user_things` (`thing_id`) ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
