<?php 
define('DOCUMENT_ROOT_CLASS','../../');
define('DOCUMENT_ROOT_INC_FOLDER','inc/');
$filepath = realpath(dirname(__FILE__));
require "../../inc/header.php";
$msg = Session::get('msg');
Session::set("msg", NULL);
$productData = $commonFunctions->getRowData('invty_pdt_details'," WHERE id = '".@$_GET['product_id']."' ");
?>
	<!-- Page Content-->
    <div class="page-content">
        <div class="container-fluid">
            <!-- Page-Title -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box">
                        <div class="row">
                            <div class="col form-row">
                            	<div class="col-sm-9">
	                                <h4 class="page-title"><?php echo @$productData['label'];?></h4>
	                                <ol class="breadcrumb">
	                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Products & Services</a></li>
	                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Products</a></li>
	                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Products Details</a></li>
	                                </ol>
	                            </div>
                                <div class="col-sm-3">
	                                <a href="product.php?state=edit&product_id=<?php echo $productData['id'];?>">
	                                	<button type="button" class="btn btn-sm btn-outline-primary">Edit</button>
	                                </a>
	                                <a href="product.php?state=copy&product_id=<?php echo $productData['id'];?>">
	                                	<button type="button"class="btn btn-sm btn-outline-dark">Duplicate</button>
	                                </a>
	                                <a href="product.php?state=list"><button type="button" class="btn btn-sm btn-outline-secondary clear_form">Back to Products List</button></a>
	                                <!-- <button type="button" class="btn btn-sm btn-outline-danger">Delete</button> -->
	                            </div>
                            </div><!--end col-->
                        </div><!--end row-->                                                              
                    </div><!--end page-title-box-->
                </div><!--end col-->
            </div><!--end row-->
            <!-- end page title end breadcrumb -->

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="dastone-profile">
                                <div class="row">
                                    <div class="col-lg-3 align-self-center mb-lg-0">
                                        <div class="dastone-profile-main">
                                            <div class="dastone-profile_user-detail">
                                                <img src="../../uploads/product-services/product-images/<?php echo @$productData['product_images'];?>" width="80px">                                              
                                            </div>
                                        </div>                                                
                                    </div><!--end col-->
                                    <div class="col-lg-4 align-self-center mb-lg-0">
                                        <div class="dastone-profile-main">
                                            <div class="dastone-profile_user-detail">
                                                <?php 
                                                $barcode_type = $commonFunctions->getname($productData['barcode_type'],'sys_erp_adm_barcode_type','label','id');
                                                //echo "<img alt='testing' src='../../lib/barcode.php?codetype=".$barcode_type."&size=40&text=".@$productData['barcode_value']."&print=true'/>";
                                                ?>
                                                <div id="barcodeTarget" class="barcodeTarget"></div>
												<canvas id="canvasTarget" width="150" height="150"></canvas>
                                            </div>
                                        </div>                                                
                                    </div><!--end col-->
                                    <div class="col-lg-5 align-self-center mb-lg-0">
                                        <div class="dastone-profile-main">
                                            <div class="dastone-profile_user-detail">
                                            	<b><?php echo @$productData['label'];?></b><br>
                                            	<?php 
                                            	$stock = $commonFunctions->getname($productData['id'],"invty_pdt_stock_mgt","SUM(stock_count)","product_id");

                                            	if(@$stock != 0 OR $productData['virtual_stock'] != 0): ?>
                                                	<span style="color: green;">IN STOCK</span>
                                                <?php else: ?>
                                                	<span style="color: red;">OUT OF STOCK</span>
                                                <?php endif; ?>
                                            </div>
                                        </div>                                                
                                    </div><!--end col-->

                                </div><!--end row-->
                            </div><!--end f_profile-->                                                                                
                        </div><!--end card-body-->          
                    </div> <!--end card-->    
                </div><!--end col-->
            </div><!--end row-->
            <div class="pb-4">
                <ul class="nav-border nav nav-pills mb-0" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="product_details_tab" data-toggle="pill" href="#product_details">Product Details</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="purchase_details_tab" data-toggle="pill" href="#purchase_details">Purchase Statistics</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="related_invoice_tab" data-toggle="pill" href="#related_invoice">Sales Statistics</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="stock_statistics_tab" data-toggle="pill" href="#stock_statistics">Stock Statistics</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="stock_mov_statistics_tab" data-toggle="pill" href="#stock_mov_statistics">Stock Movements Statistics</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="statistics_tab" data-toggle="pill" href="#statistics">Statistics</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="note_tab" data-toggle="pill" href="#note">Note</a>
                    </li>
                </ul>        
            </div><!--end card-body-->
            <style type="text/css">
            	label.form-control1 {display: block;}
            	label.label-title {font-weight: 600;}
            </style>
            <div class="row">
                <div class="col-12">
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="product_details" role="tabpanel" aria-labelledby="product_details_tab">
                        	<div class="card">
                        		<div class="card-body">
		                        	<div class="form-row">
		                        		<div class="col-md-6">
			                        		<table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline" style="border-collapse: collapse; border-spacing: 0px; width: 100%;" role="grid" aria-describedby="datatable-buttons_info">
	                                        	<thead>
		                                        	<tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Label / Product Name</td>
			                                            <td style=""><?php echo @$productData['label'];?></td>
			                                        </tr>
		                                    	</thead>
		                                    	<tbody>
		                                    		<tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Reference Number</td>
			                                            <td style=""><?php echo @$productData['reference_number'];?></td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Barcode Value</td>
			                                            <td style=""><?php echo @$productData['barcode_value'];?></td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Barcode Type</td>
			                                            <td style=""><?php
					                                    $barcodeArr = $commonFunctions->getData('sys_erp_adm_barcode_type',' WHERE active = 1 ');
					                                    foreach ($barcodeArr as $row) { ?>
					                                        <?php echo (@$productData['barcode_type'] == $row['id'])?$row['label']:"";?>
					                                    <?php } ?></td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Nature</td>
			                                            <td style="">
			                                            	<?php echo (@$productData['nature'] == 0)?"Raw Material":"";?>
			                                    			<?php echo (@$productData['nature'] == 1)?"Manufactured Product":"";?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Tags / Categories</td>
			                                            <td style="">
			                                            	<?php $TagData = $commonFunctions->getData('invty_pdt_tag',''); ?>
			                                    
						                                    <?php foreach ($TagData as $rw) { ?>
						                                        <?php if(@$productData['tag_id'] == $rw['id']){
							                                        if($rw['parent_id'] > 0){
							                                            echo $commonFunctions->getName($rw['parent_id'],'crm_cust_tag','label','id')." >> ";           
							                                        }
							                                        echo $rw['label']; 
							                                    } ?>
						                                    <?php } ?>
			                                            </td>
			                                        </tr>

			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Warehouse</td>
			                                            <td style="">
			                                            	<?php $warehouseData = $commonFunctions->getData('invty_wrhus',' WHERE status = 0 '); ?>
						                                    <?php foreach ($warehouseData as $rw) { ?>
						                                        <?php echo (@$productData['default_warehouse_id'] == $rw['id'])?$rw['short_name_location']:"";?>
						                                    <?php } ?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Use Lot / Serial Number</td>
			                                            <td style="">
			                                            	<?php echo (@$productData['lot_serial_status'] == 0)?"No ( Lot / Serial not Used )":"";?><?php echo (@$productData['lot_serial_status'] == 1)?"Yes ( Lot / Serial Required )":"";?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Note (not visible on Invoices, Proposals...)</td>
			                                            <td style="">	
						                                    <?php echo @$productData['note'];?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Selling Type</td>
			                                            <td style="">	
						                                    <?php echo (@$productData['selling_type'] == 0)?"Fixed Amount":"";?><?php echo (@$productData['selling_type'] == 1)?"Recurring Amount":"";?>
			                                            </td>
			                                        </tr>
		                                    	</tbody>
		                                    </table>
		                                </div>
		                                <div class="col-md-6">
			                        		<table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline" style="border-collapse: collapse; border-spacing: 0px; width: 100%;" role="grid" aria-describedby="datatable-buttons_info">
	                                        	<thead>
		                                        	<tr role="row" class="even">
			                                            <td tabindex="0" class="sorting_1">Sales Status</td>
			                                            <td style=""><?php echo (@$productData['sales_status'] == 1)?"For Sale":"";?><?php echo (!empty($productData) and @$productData['sales_status'] == 0)?"Not For Sale":"";?></td>
			                                        </tr>
			                                    </thead>
			                                    <tbody>
			                                        <tr role="row" class="odd">
			                                            <td tabindex="0" class="">Purchase Status</td>
			                                            <td style="">
			                                            	<?php echo (@$productData['purchase_status'] == 1)?"For Purchase":"";?>
			                                    			<?php echo (!empty($productData) and @$productData['purchase_status'] == 0)?"Not For Purchase":"";?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Selling Price</td>
			                                            <td style="">	
						                                    <div style="display: flex;">
							                                    <label style="width:70%" class="form-control1">
							                                    	<?php echo (empty(@$productData['price']))?0:@$productData['price'];?>
							                                    </label>
							                                    <label class="form-control1" style="width:30%">
							                                        <?php echo (@$productData['nature'] == "HT")?"Net of TAX":"";?>
							                                        <?php echo (@$productData['nature'] == "TTC")?"Inc. TAX":"";?>
							                                    </label>
							                                </div>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Stock Limit for Alert</td>
			                                            <td style="">	
						                                    <?php echo (empty(@$productData['stock_limit_alert']))?0:@$productData['stock_limit_alert'];?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Desired Optimal Stock</td>
			                                            <td style="">	
						                                    <?php echo (empty(@$productData['desired_optimal_stock']))?0:@$productData['desired_optimal_stock'];?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Buying Price</td>
			                                            <td style="">	
						                                    <?php echo @$productData['buying_price'];?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Cost Price</td>
			                                            <td style="">	
						                                    <?php echo @$productData['cost_price'];?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Min. Selling Price</td>
			                                            <td style="">	
						                                    <?php echo (empty(@$productData['min_price ']))?0:@$productData['min_price '];?>
			                                            </td>
			                                        </tr>
			                                        <tr role="row" class="even">
			                                            <td tabindex="0" class="">Duration</td>
			                                            <td style="">	
						                                    <div style="display: flex;">   
							                                    <label type="text" class="form-control1" style="width:70%">
							                                    	<?php echo @$productData['duration'];?>
							                                    </label>
							                                    <label class="form-control1" style="width:30%">
							                                        <?php echo (@$productData['nature'] == "i")?"I":"";?><?php echo (@$productData['nature'] == "h")?"H":"";?><?php echo (@$productData['nature'] == "d")?"D":"";?><?php echo (@$productData['nature'] == "w")?"W":"";?><?php echo (@$productData['nature'] == "m")?"M":"";?><?php echo (@$productData['nature'] == "y")?"Y":"";?>
							                                    </label>
							                                </div>
			                                            </td>
			                                        </tr>
			                                        
		                                    	</tbody>
		                                    </table>
		                                </div>
			                        </div>
			                    </div>
                        	</div>
                        </div>
                        <div class="tab-pane" id="purchase_details" role="tabpanel" aria-labelledby="purchase_details_tab">
                            <div class="card">
                        		<div class="card-body">
                                	Purchase Statistics
                            	</div><!--end row-->    
                            </div>
                        </div>
                        <div class="tab-pane" id="related_invoice" role="tabpanel" aria-labelledby="related_invoice_tab">
                            <div class="card">
                        		<div class="card-body">
                                	Sales Statistics
                            	</div><!--end row-->    
                            </div> <!--end row-->
        				</div>
        				<div class="tab-pane" id="stock_mov_statistics" role="tabpanel" aria-labelledby="stock_mov_statistics_tab">
                            <div class="card">
                        		<div class="card-body">
                                	<?php 
                                	$where1 = " WHERE product_id = '".@$_GET["product_id"]."' ";
                                	$invtData1 = $commonFunctions->getData('invty_pdt_stock_mgt_mov',$where1); ?>
                                	<table style="margin-top: 10px;width: 100% !important;" class="table datatable_t table-hover table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th class="text-center">Current Warehouse</th>
                                                <th class="text-center">Current Stock</th>
                                                <th class="text-center">Destination Warehouse</th>
                                                <th class="text-center">Move Stock</th>
                                                <th class="text-center">Stock Movements Status</th>
                                                <th class="text-center">Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            foreach ($invtData1 as $row) { 
                                                $stock_id = $row["stock_id"];
                                            ?>
                                                <tr>
                                                    <th class="text-center">
                                                        <?php echo $commonFunctions->getname($row['current_warehouse_id'],"invty_wrhus","short_name_location","id");
                                                        ?>
                                                    </th>
                                                    <th class="text-center">
                                                        <?php echo $row['current_stock']; ?>
                                                    </th>
                                                    <th class="text-center">
                                                        <?php echo $commonFunctions->getname($row['move_warehouse_id'],"invty_wrhus","short_name_location","id");
                                                        ?>
                                                    </th>
                                                    <th class="text-center">
                                                        <?php echo $row['move_stock_count']; ?>
                                                    </th>
                                                    <th class="text-center">
                                                    	<?php 
					                                	$whereLog1 = " WHERE product_id = '".@$_GET["product_id"]."' and warehouse_id = '".$row['current_warehouse_id']."' ";
					                                	$invtDataLogs1 = $commonFunctions->getData('invty_pdt_stock_mgt_logs',$whereLog1); 
					                                	foreach ($invtDataLogs1 as $r)
					                                	{
					                                		if($r["stock_mvt_status"] < 3){
					                                			echo $r["message"]." By <b style='color:purple;'>".$commonFunctions->getname($r['added_by'],"erp_sys_users","erp_sys_user_name_first","id")." ".$commonFunctions->getname($r['added_by'],"erp_sys_users","erp_sys_user_name_last","id")."</b> On <b style='color:purple;'>".date("d-m-Y h:i:s",strtotime($r['added_date']))."</b><br>";
					                                		}
					                                		if($r["stock_mvt_status"] == 4 OR $r["stock_mvt_status"] == 3){
					                                			echo "Approved By <b style='color:purple;'>".$commonFunctions->getname($r['appr_staff_id'],"erp_sys_users","erp_sys_user_name_first","id")." ".$commonFunctions->getname($r['appr_staff_id'],"erp_sys_users","erp_sys_user_name_last","id")."</b> On <b style='color:purple;'>".date("d-m-Y h:i:s",strtotime($r['added_date']))."</b><br>";
					                                		}
					                                		if($r["stock_mvt_status"] == 4){
					                                			echo "Completed By <b style='color:purple;'>".$commonFunctions->getname($r['accept_staff_id'],"erp_sys_users","erp_sys_user_name_first","id")." ".$commonFunctions->getname($r['accept_staff_id'],"erp_sys_users","erp_sys_user_name_last","id")."</b> On <b style='color:purple;'>".date("d-m-Y h:i:s",strtotime($r['added_date']))."</b><br>";
					                                		}
					                                	}
					                                	?>
                                                    </th>
                                                    <th class="text-center">
                                                        <?php 
                                                        if($row['stock_mvt_status'] == 1){
                                                            echo "<span class='btn btn-danger'>Drafted</span>";
                                                        }
                                                        if($row['stock_mvt_status'] == 2){
                                                            echo "<span class='btn btn-warning'>Inprogress</span>";
                                                        }
                                                        if($row['stock_mvt_status'] == 3){
                                                            echo "<span class='btn btn-primary'>Approved</span>";
                                                        }
                                                        if($row['stock_mvt_status'] == 4){
                                                            echo "<span class='btn btn-success'>Completed</span>";
                                                        }
                                                        ?>
                                                    </th>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                            	</div><!--end row-->    
                            </div> <!--end row-->
        				</div>
                        <div class="tab-pane" id="stock_statistics" role="tabpanel" aria-labelledby="stock_statistics_tab">
                            <div class="card">
                        		<div class="card-body">
                                	<?php 
                                	$where = " WHERE product_id = '".@$_GET["product_id"]."' ";
                                	$invtData = $commonFunctions->getData('invty_pdt_stock_mgt',$where); ?>
                                	<table style="margin-top: 10px;width: 100% !important;" class="table datatable_t table-hover table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th class="text-center">Warehouse</th>
                                                <th class="text-center">Physical Stock</th>
                                                <th class="text-center">Virtual Stock</th>
                                                <th class="text-center">Total Stock</th>
                                                <th class="text-center">Selling Price</th>
                                                <th class="text-center">Total Value</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            foreach ($invtData as $row) { 
                                                $stock_id = $row["stock_id"];
                                            ?>
                                                <tr>
                                                	<th class="text-center">
                                                        <?php echo $commonFunctions->getname($row['warehouse_id'],"invty_wrhus","short_name_location","id");
                                                        ?>
                                                    </th>
                                                    <th class="text-center">
                                                    	<?php echo $row['stock_count'];?>
                                                    </th>
                                                    <th class="text-center">
                                                    	0
                                                    </th>
                                                    <th class="text-center"><?php echo $row['stock_count'];?></th>
                                                    <th class="text-center">
                                                        <?php
                                                        echo $commonFunctions->getname($row['product_id'],"invty_pdt_details","price","id"); ?>
                                                    </th>
                                                    <th class="text-center"><?php 
                                                        $stock_count = (int)$row['stock_count'];
                                                        $selling_price = (int)$commonFunctions->getname($row['product_id'],"invty_pdt_details","price","id");
                                                        echo $stock_count * $selling_price;
                                                    ?></th>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                            	</div><!--end row-->    
                            </div>
                        </div>
                        <div class="tab-pane" id="statistics" role="tabpanel" aria-labelledby="statistics_tab">
                            <div class="card">
                        		<div class="card-body">
                                	Statistics
                            	</div><!--end row-->    
                            </div>
                        </div>
                        <div class="tab-pane" id="note" role="tabpanel" aria-labelledby="note_tab">
                            <div class="card">
                        		<div class="card-body">
	                            	<div class="form-row">
	                            		<div class="col-md-12 position-relative form-group">
	                            			<?php echo @$productData['description'];?>
	                            		</div>
	                            	</div>
	                            </div>
                            </div><!--end row-->
                        </div>
                    </div>
                </div>
            </div>

        </div><!-- container -->
    </div>
    <!-- end page content -->
<?php require "../../inc/footer.php"; ?>
<script type="text/javascript" src="https://www.jqueryscript.net/demo/Simple-jQuery-Based-Barcode-Generator-Barcode/jquery-barcode.js"></script>
<script type="text/javascript">
    
  	function generateBarcode(){
	    var value = "<?php echo strtolower(@$productData['barcode_value']); ?>";
	    var btype = "<?php echo strtolower(@$barcode_type); ?>";
	    var renderer = "css";
    	var quietZone = false;
	    
	    var settings = {
	      	output:renderer,
	      	bgColor: "#FFFFFF",
	      	color: "#000000",
	      	barWidth: "2",
	     	barHeight: "50",
	      	moduleSize: "5",
	      	posX: "10",
	      	posY: "20",
	      	addQuietZone: "1"
	    };
    	if (renderer == 'canvas'){
      		clearCanvas();
	      	$("#barcodeTarget").hide();
	      	$("#canvasTarget").show().barcode(value, btype, settings);
    	} else {
      		$("#canvasTarget").hide();
      		$("#barcodeTarget").html("").show().barcode(value, btype, settings);
    	}
  	}
      
  	function showConfig1D(){
	    $('.config .barcode1D').show();
	    $('.config .barcode2D').hide();
  	}
  
  	function showConfig2D(){
	    $('.config .barcode1D').hide();
	    $('.config .barcode2D').show();
  	}
  
  	function clearCanvas(){
	    var canvas = $('#canvasTarget').get(0);
	    var ctx = canvas.getContext('2d');
	    ctx.lineWidth = 1;
	    ctx.lineCap = 'butt';
	    ctx.fillStyle = '#FFFFFF';
	    ctx.strokeStyle  = '#000000';
	    ctx.clearRect (0, 0, canvas.width, canvas.height);
	    ctx.strokeRect (0, 0, canvas.width, canvas.height);
  	}
  
  	$(function(){
    	generateBarcode();
  	});

</script>